/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.mc6809;

import frc.emul.api.Execution;
import frc.emul.api.IAddressBinder;
import frc.emul.api.ILogger;
import frc.emul.api.IMemory;
import frc.emul.api.IRawCPU;
import frc.emul.api.ISimulator;
import frc.emul.api.persistence.IPersistenceReader;
import frc.emul.api.persistence.IPersistenceWriter;
import frc.emul.api.persistence.IPersistentObject;
import frc.emul.api.persistence.IPersistentSection;
import frc.emul.api.persistence.PersistenceException;
import frc.emul.mc6809.Instruction;
import frc.emul.mc6809.Instructions;
import frc.emul.mc6809.MC6809Logger;
import frc.emul.mc6809.MC6809Sim;
import frc.emul.mc6809.Regs;
import frc.emul.vectrex.PersistentSection;

public final class MC6809
implements IRawCPU,
IPersistentObject {
    private final transient float freq;
    private final transient Regs regs;
    private final transient ISimulator simulator;
    private final transient Instructions instructions;
    private transient IMemory mem;
    private transient IAddressBinder binder;
    private transient ILogger logger;
    private long cycles;

    public MC6809(float f, boolean bl) {
        this.freq = f;
        this.regs = new Regs();
        this.simulator = new MC6809Sim(this);
        this.instructions = new Instructions(this.simulator.getClass(), bl);
    }

    public ILogger getLogger() {
        if (this.logger == null) {
            this.logger = new MC6809Logger(this);
        }
        return this.logger;
    }

    public void setMemory(IMemory iMemory, IAddressBinder iAddressBinder) {
        this.mem = iMemory;
        this.binder = iAddressBinder;
    }

    public IMemory getMemory() {
        return this.mem;
    }

    public IAddressBinder getBinder() {
        return this.binder;
    }

    public ISimulator getSimulator() {
        return this.simulator;
    }

    public Instruction getCurrentInstruction() {
        return this.instructions.fetch(this.mem, this.regs.PC());
    }

    public void reset() {
        this.simulator.reset();
    }

    public final int getCurrentPC() {
        return this.regs.PC();
    }

    public final int getLastPC() {
        return this.simulator.getLastExecutedAddress();
    }

    public IPersistentSection getSection() {
        return PersistentSection.CPU;
    }

    public void store(IPersistenceWriter iPersistenceWriter) throws PersistenceException {
        iPersistenceWriter.write((IPersistentObject)((Object)this.simulator));
        iPersistenceWriter.write(this.regs);
        iPersistenceWriter.write(this.cycles);
    }

    public void load(IPersistenceReader iPersistenceReader) throws PersistenceException {
        iPersistenceReader.read((IPersistentObject)((Object)this.simulator));
        iPersistenceReader.read(this.regs);
        this.cycles = iPersistenceReader.readLong();
    }

    public Regs getRegisters() {
        return this.regs;
    }

    public long getCycles() {
        return this.cycles;
    }

    public float getFrequency() {
        return this.freq;
    }

    public void setCycles(long l) {
        this.cycles = l;
    }

    public void advanceCycles(int n) {
        this.cycles += (long)n;
    }

    public final void initialise() {
        MC6809Sim mC6809Sim = (MC6809Sim)this.simulator;
        mC6809Sim.initialise(this.binder);
    }

    public Exception getLastError() {
        return this.simulator.getLastError();
    }

    public final Execution step() {
        Execution execution;
        MC6809Sim mC6809Sim = (MC6809Sim)this.simulator;
        try {
            Instruction instruction = this.instructions.fetch(this.mem, this.regs.PC());
            execution = mC6809Sim.execute(instruction);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            return Execution.FATAL_ERR;
        }
        if (execution == Execution.FATAL_ERR) {
            mC6809Sim.getLastError().printStackTrace(System.err);
        }
        return execution;
    }
}

